<?php defined('BASEPATH') OR exit('No direct script access allowed');

// This can be removed if you use __autoload() in config.php OR use Modular Extensions
require APPPATH.'/libraries/REST_Controller.php';

class Onboarding extends CI_Controller
{
	public function __construct(){
		parent::__construct();
		$this->load->library(array('session','encrypt','eventlog','permissions','auth'));
		$this->load->model('applicationmodel');
		$this->load->model('applicationrequestmodel');
		$this->load->model('requestmodel');
		$this->load->model('usersmodel');
		$this->load->model('ticketsmodel');
		$this->load->model('ticketcategorymodel');
		$this->load->helper('url'); 
		
		//check if the user is authorized
		$login_status = $this->session->userdata('is_loggedin');
		if(!isset($login_status) || $login_status !== 'true') {
			//if the user has authenticated via CAC, the controller will load 
			//if not then a 401 Unauthorized error will be shown
			if(!$this->auth->perform_auth()) { show_error('Unauthorized',401); }
		}
		
		//check if user has agreed to dod banner
		$banner = $this->session->userdata('banner_agree');
		if ((!isset($banner) || $banner !== 'true') 
				&& 'onboarding/banner' !== uri_string() 
				&& 'onboarding/banner_agree' !== uri_string()) {
			$this->session->set_flashdata('redirect_uri',uri_string());
			redirect('onboarding/banner');
		}
	}
	
	public function index() {
		$this->onboarding();
	}
	
	/* -----------------------------*
	 *  ONBOARDING TAB FUNCTIONS    *
	 * -----------------------------*/
	
	/*
	 * This will return a view of the DoD banner.
	 */
	public function banner(){
		//set the view title
		$data['title'] = WARNING_BANNER_PAGE_TITLE;
		//set the active tabs
		$data['active_tab'] = array('onboarding'=>true);
		//pull the banner text from constants
		$data['banner'] = WARNING_BANNER;
		
		//set the location to redirect to
		if(strlen($this->session->flashdata('redirect_uri')) > 0) { $data['redirect_uri'] = $this->session->flashdata('redirect_uri'); }
		
		//get user id from session to get permissions
		$id = $this->encrypt->decode($this->session->userdata('user_id'));
		$permissions = $this->permissions->get_user_permissions($id);
		
		$this->load->view('api/onboarding/banner', $data);
	}
	
	/*
	 * This function will set the banner_agree variable if the user agrees and redirects them to where they wanted to go
	 */
	public function banner_agree(){
		$redirect_uri = $this->input->post('redirect_uri', TRUE);
		echo $redirect_uri;
		$this->session->set_userdata('banner_agree','true');
		
		if (isset($redirect_uri) && strlen($redirect_uri) > 0){
			redirect($redirect_uri);
		}else{
			redirect('onboarding');
		}
	}
	
	/*
	 * Onboarding is the main page a user will see when first accessing the site. 
	 */
	public function onboarding() {
		$this->load->model('applicationmodel');
		$this->load->model('accountrequestmodel');
		$data['title'] = 'Direct API: Onboarding';
		$data['active_tab'] = array('onboarding'=>true);
		
		//get user id from session to get permissions
		$id = $this->encrypt->decode($this->session->userdata('user_id'));
		$user_id = $this->usersmodel->get_user_id_from_org_id($id);
		$permissions = $this->permissions->get_user_permissions($id);
		$query = $this->ticketcategorymodel->get_id_from_category('Contact');
		$category = null;
		if ($query !== false){
			$category = $query->result();
			$category = $category[0]->id;
		}
		$data['category'] = $category;
		$data['sent_message'] = $this->ticketsmodel->message_sent_within_24_hours($user_id, $category);
		$data['show'] = $this->permissions->set_tab_access_from_permissions($permissions);
		$data['registered'] = $permissions['Registered'];
		$data['status'] = $this->accountrequestmodel->request_status($id);
		
		if(strlen($this->session->flashdata('error_message')) > 0) {
			$data['error_message'] = $this->session->flashdata('error_message');
			//add post data to from flashdata
			$data['support_message'] = $this->session->flashdata('support_message');
		}
		
		if(strlen($this->session->flashdata('success_message')) > 0) {
			$data['success_message'] = $this->session->flashdata('success_message');
		}
		
		$this->load->view('api/onboarding/onboarding', $data);
	}
	
	/* 
	 * Onboarding request is the page where a user can request application access. 
	 */
	public function onboarding_request() {
		$this->load->model('accountrequestmodel');
		$data['title'] = 'Direct API: Application Request';
		$data['active_tab'] = array('onboarding'=>true);
		
		//get user id from session to get permissions
		$id = $this->encrypt->decode($this->session->userdata('user_id'));
		$permissions = $this->permissions->get_user_permissions($id);
		$data['show'] = $this->permissions->set_tab_access_from_permissions($permissions);
		
		//load validation errors from flashdata if necessary
		if(strlen($this->session->flashdata('error_message')) > 0) { 
			$data['error_message'] = $this->session->flashdata('error_message');
			//add post data to from flashdata
			$data['app_name'] = $this->session->flashdata('app_name');
			$data['app_url'] = $this->session->flashdata('app_url');
			$data['app_desc'] = $this->session->flashdata('app_desc');
			$data['app_just'] = $this->session->flashdata('app_just');
			$data['poc_name'] = $this->session->flashdata('app_poc_name');
			$data['poc_email'] = $this->session->flashdata('app_poc_email');
			$data['poc_phone'] = $this->session->flashdata('app_poc_phone');
		}
		
		//load view based on user permissions
		if($permissions['Registered']) { $this->load->view('api/onboarding/app_request', $data); }
		else {
			//create account form data
			$data['user_name'] = $this->session->flashdata('user_name');
			$data['user_org_id'] = $this->session->flashdata('user_org_id');
			$data['status'] = $this->accountrequestmodel->request_status($id);
			
			$account_request_data = $this->accountrequestmodel->get_account_request_data($id);
			$data['first_name'] = $account_request_data['first_name'];
			$data['middle_name'] = $account_request_data['middle_name'];
			$data['last_name'] = $account_request_data['last_name'];
			$data['ext_mail'] = $account_request_data['ext_mail'];
			$data['account_title'] = $account_request_data['title'];
			$data['organization'] = $account_request_data['organization'];
			$data['department'] = $account_request_data['department'];
			$data['telephone'] = $account_request_data['telephone'];
			$data['mobile'] = $account_request_data['mobile'];
			$data['location'] = $account_request_data['location'];
			$data['justification'] = $account_request_data['justification'];
			
			$this->load->view('api/onboarding/account_request', $data); 
		}
	}
	
	/*
	 * Onboarding request edit is a function for editing existing requests.
	 */
	public function onboarding_request_edit($id = null)
	{
		if(is_null($id)) { return $this->application_list(); } //if no id is set, go back to application list
		$data['title'] = 'Direct API: Request Edit';
		$data['active_tab'] = array('onboarding'=>true);
		//get user id from session to get permissions
		$user_id = $this->encrypt->decode($this->session->userdata('user_id'));
		$user_db_id = $this->usersmodel->get_user_id_from_org_id($user_id);
		$permissions = $this->permissions->get_user_permissions($user_id);
		$data['show'] = $this->permissions->set_tab_access_from_permissions($permissions);
		
		//load validation errors from flashdata if necessary
		if(strlen($this->session->flashdata('error_message')) > 0) {
			$data['error_message'] = $this->session->flashdata('error_message');
			//add post data to from flashdata
			$data['app_name'] = $this->session->flashdata('app_name');
			$data['app_url'] = $this->session->flashdata('app_url');
			$data['app_desc'] = $this->session->flashdata('app_desc');
			$data['app_just'] = $this->session->flashdata('app_just');
			$data['poc_name'] = $this->session->flashdata('app_poc_name');
			$data['poc_email'] = $this->session->flashdata('app_poc_email');
			$data['poc_phone'] = $this->session->flashdata('app_poc_phone');
		}
		
		if($data['show']['applications']) {
			if (isset($id) && is_numeric($id)){ //make sure its a valid id
				$request = $this->applicationrequestmodel->get_request($id)->result();
				if($permissions['API']['admins'] || $request[0]->requestor === $user_db_id) {
					if($request) { //if there is a result, load the view
						$data['request'] = $request[0];
						$this->load->view('api/onboarding/app_request_edit', $data);
					}
					else { show_404(); } //if not valid id or no result, show 404
				}else{ show_error('Forbidden',403); }
			}
			else { show_404(); }
		}else { show_error('Forbidden',403); }
	}
	
	/*
	 * Send is the API documentation for the send web service. 
	 */
	public function send() {
		$data['title'] = 'Direct API: Send';
		$data['active_tab'] = array('onboarding'=>true);
		
		//get user id from session to get permissions
		$id = $this->encrypt->decode($this->session->userdata('user_id'));
		$permissions = $this->permissions->get_user_permissions($id);
		$data['show'] = $this->permissions->set_tab_access_from_permissions($permissions);
		
		$this->load->view('api/onboarding/send', $data);
	}
	
	/*
	 * Examples of calling the send code
	*/
	public function send_example() {
		$data['title'] = 'Direct API: Send Code Example';
		$data['active_tab'] = array('onboarding'=>true);
		
		//get user id from session to get permissions
		$id = $this->encrypt->decode($this->session->userdata('user_id'));
		$permissions = $this->permissions->get_user_permissions($id);
		$data['show'] = $this->permissions->set_tab_access_from_permissions($permissions);
		
		$this->load->view('api/onboarding/send_example', $data);
	}
	
	/*
	 * Validate is the API documentation for the validate web service.
	 */
	public function validate() {
		$data['title'] = 'Direct API: Validate';
		$data['active_tab'] = array('onboarding'=>true);
		
		//get user id from session to get permissions
		$id = $this->encrypt->decode($this->session->userdata('user_id'));
		$permissions = $this->permissions->get_user_permissions($id);
		$data['show'] = $this->permissions->set_tab_access_from_permissions($permissions);
		
		$this->load->view('api/onboarding/validate', $data);
	}
	
	/*
	 * Examples of calling the validate code
	*/
	public function validate_example() {
		$data['title'] = 'Direct API: Validate Code Example';
		$data['active_tab'] = array('onboarding'=>true);
		
		//get user id from session to get permissions
		$id = $this->encrypt->decode($this->session->userdata('user_id'));
		$permissions = $this->permissions->get_user_permissions($id);
		$data['show'] = $this->permissions->set_tab_access_from_permissions($permissions);
		
		$this->load->view('api/onboarding/validate_example', $data);
	}
	
	/* 
	 * App request save handles the save of the request information into the database. 
	 */
	public function app_request_save()
	{
		$this->load->library(array('encrypt','form_validation'));
		$this->load->model('usersmodel');
		$this->load->library('email');
		$this->load->library('external_notifications');
		
		//grab the admin accounts and their emails for external notifications
		$admins = $this->permissions->get_daas_admins();
		$emails = $this->usersmodel->get_emails_from_uid_array($admins);
		
		//collect request form information
		$id = $this->input->post('app_id', TRUE);
		$name = $this->input->post('app_name', TRUE);
		$url = $this->input->post('app_url', TRUE);
		$desc = $this->input->post('app_desc', TRUE);
		$just = $this->input->post('app_just', TRUE);
		$poc_name = $this->input->post('app_poc_name', TRUE);
		$poc_email = $this->input->post('app_poc_email', TRUE);
		$poc_phone = $this->input->post('app_poc_phone', TRUE);

		//validation of form values
		if (strlen(trim($id)) > 0){
			$request_arr = $this->applicationrequestmodel->get_request($id)->result();
			$req = $request_arr[0];
			$existing_name = $req->name;
			if ($existing_name === $name){
				$this->form_validation->set_rules('app_name','Application Name','required|max_length[100]');
			}else{
				$this->form_validation->set_rules('app_name','Application Name','required|is_unique[application_request.name]|max_length[100]');
			}
		}else{
			$this->form_validation->set_rules('app_name','Application Name','required|is_unique[application_request.name]|max_length[100]');
		}
		$this->form_validation->set_rules('app_url','Application URL','required|max_length[1000]');
		$this->form_validation->set_rules('app_desc','Application Description','required|max_length[4000]');
		$this->form_validation->set_rules('app_just','Justification','required|max_length[4000]');
		$this->form_validation->set_rules('app_poc_name','POC Name','required|max_length[500]');
		$this->form_validation->set_rules('app_poc_email','POC Email','required|valid_email|max_length[100]');
		$this->form_validation->set_rules('app_poc_phone','POC Phone','required|validate_phone|max_length[20]');
		$is_denied = 0;
		
		//if it passes the validation checks
		if($this->form_validation->run() === TRUE) {
			//determine id
			$user_id = $this->encrypt->decode($this->session->userdata('user_id'));
			$user_db_id = $this->usersmodel->get_user_id_from_org_id($user_id);
			
			//if the request already exists then update it
			if(strlen(trim($id)) > 0) {
				$request = $this->applicationrequestmodel->get_request($id)->result();
				$is_denied = $request[0]->denied;
				//use permissions to determine whether to allow function call at all
				$permissions = $this->permissions->get_user_permissions($user_id);
				if($permissions['API']['admins'] || $request[0]->requestor === $user_db_id) {
					$this->applicationrequestmodel->update_request($id, $name, $url, $desc, $just, $poc_name, $poc_email, $poc_phone);
					$this->session->set_flashdata('success_message', 'Request for application "'.$name.'" has been updated successfully.');
					
					$mail_subject = 'Request for application "'.$name.'" has been updated and is waiting approval.';
					$mail_message = "Admins,\r\n\r\nAn application request has been updated and is awaiting approval.\r\n\r\nhttps://".API_ADMINPANEL_DOMAIN."/administration/application/requests\r\n\r\nThank you,\r\n".EMAIL_SIGNATURE;
					$this->external_notifications->send_message($emails, $mail_subject, $mail_message);
					
					$this->eventlog->create_event( 1,$id,3 ,$user_db_id, "Application request updated", time(), 1);
					
					//TODO: find way to get external email to send through relay
				}else{$this->eventlog->create_event( 1,$id,3 ,$user_db_id, "Application request updated", time(), 2); show_error('Forbidden',403); }
			}
			//if the request doesn't exist then add a new one
			else {
				$requestor = $this->usersmodel->get_user_id_from_org_id($this->encrypt->decode($this->session->userdata('user_id')));
				if(!$requestor) { 
					$this->session->set_flashdata('error_message','Failed to submit application request.');
					$this->eventlog->create_event( 1,0,3 ,$user_db_id, "Application request created", time(), 0);
					$form_data = $this->input->post(NULL);
					foreach($form_data as $key => $value) {
						$this->session->set_flashdata($key, $value);
					}
					redirect('onboarding/request');
				}
				$this->applicationrequestmodel->create_request($name, $requestor, $url, $desc, $just, $poc_name, $poc_email, $poc_phone);
				$this->session->set_flashdata('success_message', 'Request for application "'.$name.'" has been submitted successfully.');
				$new_id=$this->applicationrequestmodel->get_ids($name)->result();
				$new_id=$new_id[0]->id;
				$this->eventlog->create_event( 1,$new_id,3 ,$user_db_id, "Application request created", time(), 1);
				
				$mail_subject = 'Request for application "'.$name.'" is awaiting approval.';
				$mail_message = "Admins,\r\n\r\nA new application request is awaiting approval.\r\n\r\nhttps://".API_ADMINPANEL_DOMAIN."/administration/application/requests\r\n\r\nThank you,\r\n\r\n".EMAIL_SIGNATURE;
				$this->external_notifications->send_message($emails, $mail_subject, $mail_message);
			}
			if ($is_denied > 0){
				redirect('applications/list#denied');
			}else{
				redirect('applications/list#pending');
			}
		}
		//if it doesn't pass the validation checks then pass back the errors
		else {
			$this->session->set_flashdata('error_message',validation_errors());
			$form_data = $this->input->post(NULL);
			foreach($form_data as $key => $value) {
				$this->session->set_flashdata($key, $value);
			}
			if(strlen(trim($id)) > 0) { redirect('onboarding/request/edit/'.$id); }
			else{ redirect('onboarding/request'); }
		}
	}
	
	/* This function saves an account request to the database.
	 */
	public function account_request_save()
	{
		$this->load->library('form_validation');
		$this->load->model('accountrequestmodel');
		
		$first = $this->input->post('first_name', TRUE);
		$middle = $this->input->post('middle_name', TRUE);
		$last = $this->input->post('last_name', TRUE);
		$ext_mail = $this->input->post('ext_mail', TRUE);
		$title = $this->input->post('account_title', TRUE);
		$department = $this->input->post('department', TRUE);
		$organization = $this->input->post('organization', TRUE);
		$telephone = $this->input->post('telephone', TRUE);
		$mobile = $this->input->post('mobile', TRUE);
		$location = $this->input->post('location', TRUE);
		$user_org_id = $this->encrypt->decode($this->session->userdata('user_id'));
		
		$this->form_validation->set_rules('first_name','First Name','required');
		$this->form_validation->set_rules('last_name','Last Name','required');
		$this->form_validation->set_rules('ext_mail','Email','required|valid_email');
		$this->form_validation->set_rules('telephone','Telehone','validate_phone');
		$this->form_validation->set_rules('mobile','Mobile','validate_phone');
		
		if($this->form_validation->run() === TRUE) {
			$create = $this->accountrequestmodel->create_request($first,$middle,$last,$ext_mail,$title,$department,$organization,$telephone,$mobile,$location,$user_org_id);
			if($create) {
				$request_id = $this->db->insert_id();
				$this->eventlog->create_event(4, $request_id, 4, $request_id, "Requested account", time(), 1);
				redirect('onboarding/request');
			}
			else {
				$this->session->set_flashdata('error_message','Failed to submit request.');
				$this->eventlog->create_event(4, 0, 4, 0, "Requested account", time(), 0);
				redirect('onboarding/request');
			}
		}
		else {
			$this->session->set_flashdata('error_message',validation_errors());
			$this->session->set_flashdata('first_name', $first);
			$this->session->set_flashdata('middle_name', $middle);
			$this->session->set_flashdata('last_name', $last);
			$this->session->set_flashdata('user_name', $user_name);
			$this->session->set_flashdata('user_org_id', $user_org_id);
			$this->session->set_flashdata('ext_mail', $ext_mail);
			$this->session->set_flashdata('account_title', $account_title);
			$this->session->set_flashdata('department', $department);
			$this->session->set_flashdata('organization', $organization);
			$this->session->set_flashdata('telephone', $telephone);
			$this->session->set_flashdata('mobile', $mobile);
			$this->session->set_flashdata('location', $location);
			
			$this->session->set_flashdata('error_message',validation_errors());
			redirect('onboarding/request');
		}
	}
}